﻿using System;

namespace gov.va.med.vbecs.Common.Log
{
    /// <summary>
    /// The Global context exposes classes and data that can be used by our server components, 
    /// they are request agnostic and are kept alive along with the application. 
    /// A good approach with these global resources and services is not keeping any sort of state if feasible, 
    /// concurrency issues may arise if the design is not correct.
    /// 
    /// Multithreaded Singleton.Double-Check Locking pattern is used.
    /// </summary>
    public class LogManager
    {
        static readonly Object LocatorLock = new object();
        private static volatile LogManager _internalInstance;

        private LogManager() { }

        /// <summary>
        /// LogManager
        /// </summary>
        /// <returns></returns>
        public static LogManager Instance()
        {
            if (_internalInstance == null)
            {
                lock (LocatorLock)
                {
                    // in case of a race scenario ... check again
                    if (_internalInstance == null)
                    {
                        _internalInstance = new LogManager();
                    }
                }
            }
            return _internalInstance;
        }

        #region IGlobalContext Members

// ReSharper disable UnusedAutoPropertyAccessor.Local

        /// <summary>
        /// LoggerLocator
        /// </summary>
        public ILoggerLocator LoggerLocator { get; private set; }
// ReSharper restore UnusedAutoPropertyAccessor.Local

        #endregion
    }

}
